/**  @file bta_avg_pixels.c
*
*    @brief This file implements the filter (see header)
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/


#include "bta_avg_pixels.h"
#include <stdlib.h>
#include <string.h>

#ifndef BTA_EXCLUDE_FILTERS




BTA_Status BFLTavgPixelsInit(BTA_FltAvgPixelsConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst) {
    if (!handle || !config) {
        return BTA_StatusInvalidParameter;
    }
    *handle = 0;
    BTA_FltAvgPixelsInst *inst = (BTA_FltAvgPixelsInst *)calloc(1, sizeof(BTA_FltAvgPixelsInst));
    if (!inst) {
        return BTA_StatusOutOfMemory;
    }
	inst->channelToProcess = config->channelToProcess;
	inst->channelIdResult = config->channelIdResult;
    inst->infoEventInst = infoEventInst;
    *handle = inst;
    return BTA_StatusOk;
}


BTA_Status BFLTavgPixelsClose(BTA_FltHandle *handle) {
	BTA_FltAvgPixelsInst **inst = (BTA_FltAvgPixelsInst **)handle;
    free(*inst);
    *inst = 0;
    return BTA_StatusOk;
}


BTA_Status BFLTavgPixelsApply(BTA_FltHandle handle, BTA_Frame **frame) {
	BTA_FltAvgPixelsInst *inst = (BTA_FltAvgPixelsInst *)handle;
    if (!inst || !frame) {
        return BTA_StatusInvalidParameter;
    }
    if (!*frame) {
        return BTA_StatusInvalidParameter;
    }

	int chInd;
    int chCount = (*frame)->channelsLen;
	for (chInd = 0; chInd < chCount; chInd++) {
		BTA_Channel *channel = (*frame)->channels[chInd];
		if (!inst->channelToProcess || channel->id == inst->channelToProcess) {
			int xy;
			switch (channel->dataFormat) {

			case BTA_DataFormatUInt8: {
				uint32_t *sum = (uint32_t *)calloc(1, sizeof(uint32_t));
				for (xy = 0; xy < channel->xRes * channel->yRes; xy++) {
					*sum += ((uint8_t *)channel->data)[xy];
				}
				*sum /= channel->xRes * channel->yRes;
				if (inst->channelIdResult) {
					BTAinsertChannelDataIntoFrame(*frame, inst->channelIdResult, 1, 1, channel->dataFormat, channel->unit, channel->integrationTime, channel->modulationFrequency, (uint8_t *)sum, sizeof(uint8_t));
				}
				else {
					free(channel->data);
					channel->data = (uint8_t *)sum;
					channel->xRes = 1;
					channel->yRes = 1;
					channel->dataLen = sizeof(uint8_t);
				}
				break;
			}

            case BTA_DataFormatSInt16: {
                int32_t *sum = (int32_t *)calloc(1, sizeof(int32_t));
                for (xy = 0; xy < channel->xRes * channel->yRes; xy++) {
                    *sum += ((int16_t *)channel->data)[xy];
                }
                *sum /= channel->xRes * channel->yRes;
                if (inst->channelIdResult) {
                    BTAinsertChannelDataIntoFrame(*frame, inst->channelIdResult, 1, 1, channel->dataFormat, channel->unit, channel->integrationTime, channel->modulationFrequency, (uint8_t *)sum, sizeof(int16_t));
                }
                else {
                    free(channel->data);
                    channel->data = (uint8_t *)sum;
                    channel->xRes = 1;
                    channel->yRes = 1;
                    channel->dataLen = sizeof(int16_t);
                }
                break;
            }

            case BTA_DataFormatUInt16: {
                uint32_t *sum = (uint32_t *)calloc(1, sizeof(uint32_t));
                for (xy = 0; xy < channel->xRes * channel->yRes; xy++) {
                    *sum += ((uint16_t *)channel->data)[xy];
                }
                *sum /= channel->xRes * channel->yRes;
                if (inst->channelIdResult) {
                    BTAinsertChannelDataIntoFrame(*frame, inst->channelIdResult, 1, 1, channel->dataFormat, channel->unit, channel->integrationTime, channel->modulationFrequency, (uint8_t *)sum, sizeof(uint16_t));
                }
                else {
                    free(channel->data);
                    channel->data = (uint8_t *)sum;
                    channel->xRes = 1;
                    channel->yRes = 1;
                    channel->dataLen = sizeof(uint16_t);
                }
                break;
            }

			case BTA_DataFormatFloat32: {
				float *sum = (float *)calloc(1, sizeof(float));
				for (xy = 0; xy < channel->xRes * channel->yRes; xy++) {
					*sum += ((float *)channel->data)[xy];
				}
				*sum /= channel->xRes * channel->yRes;
				if (inst->channelIdResult) {
					BTAinsertChannelDataIntoFrame(*frame, inst->channelIdResult, 1, 1, channel->dataFormat, channel->unit, channel->integrationTime, channel->modulationFrequency, (uint8_t *)sum, sizeof(float));
				}
				else {
					free(channel->data);
					channel->data = (uint8_t *)sum;
					channel->xRes = 1;
					channel->yRes = 1;
					channel->dataLen = sizeof(float);
				}
				break;
			}
			default:
				return BTA_StatusNotSupported;
			}
		}
	}
	return BTA_StatusOk;
}

#endif
